import 'package:photogram_admin_cp/import/data.dart';
import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/form_editor_page.dart';

class DisksSection extends StatefulWidget {
  const DisksSection({Key? key}) : super(key: key);

  @override
  _DisksPageState createState() => _DisksPageState();
}

class _DisksPageState extends State<DisksSection> with AppActiveContentMixin {
  @override
  build(context) {
    var allowedValues = {
      'Local Storage': SettingEnum.storageDiskLocal,
      'AWS S3 Bucket': SettingEnum.storageDiskAws,
      'Wasabi S3 Bucket': SettingEnum.storageDiskWasabi,
      'Azure Blob Storage': SettingEnum.storageDiskAzureBlob,
    };

    return FormEditorPage(
      heading: 'Activate/Deactivate disks',
      description: 'Note: Files stored on a deactivated disks will work as long your disks are up and running in cloud,'
          ' which means you can change disk configuration anytime or you can even run multiple disks at the same time.',
      items: [
        SettingItem(
          intId: AppSettings.ID_SS_ENUM_STORAGE_DISK_USER_IMAGES,
          settingKey: AppSettings.KEY_SS_ENUM_STORAGE_DISK_USER_IMAGES,
          type: FieldType.select,
          allowedValues: allowedValues,
          leading: 'Active Disk for User Images',
          description: 'Active disk for future profile specific uploads(e.g profile picture).',
        ),
        SettingItem(
          intId: AppSettings.ID_SS_ENUM_STORAGE_DISK_POST_IMAGES,
          settingKey: AppSettings.KEY_SS_ENUM_STORAGE_DISK_POST_IMAGES,
          type: FieldType.select,
          allowedValues: allowedValues,
          leading: 'Active Disk for Post Images',
          description: 'Active disk for future post specific uploads(e.g photos uploaded in a post).',
        ),
        SettingItem(
          intId: AppSettings.ID_SS_ENUM_STORAGE_DISK_COLLECTION_IMAGES,
          settingKey: AppSettings.KEY_SS_ENUM_STORAGE_DISK_COLLECTION_IMAGES,
          type: FieldType.select,
          allowedValues: allowedValues,
          leading: 'Active Disk for Collection Images',
          description: 'Active disk for future collection specific uploads(e.g collection covers).',
        ),
      ],
    );
  }
}
